<?php
/**
 * Session information widget
 *
 * @link       https://sympose.net
 * @since      1.1.4
 *
 * @package    Sympose
 * @subpackage Sympose/admin/widgets
 */

/**
 * Session information widget
 *
 * @package    Sympose
 * @subpackage Sympose/admin/widgets
 * @author     Sympose <info@sympose.io>
 */
class Sympose_Session_Information extends WP_Widget {

	/**
	 * Sympose_Session_Information constructor.
	 */
	public function __construct() {
		parent::__construct( false, 'Sympose Session Information' );
	}

	/**
	 *
	 * The Widget
	 *
	 * @param array $args Array of args.
	 * @param array $instance instance.
	 */
	public function widget( $args, $instance ) {

		$show_on = array( 'session' );

		$id        = get_the_ID();
		$post_type = get_post_type( $id );

		if ( ! in_array( $post_type, $show_on ) ) {
			return;
		}

		// phpcs:disable

		echo $args['before_widget'];


		$title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );

		if ( isset( $instance['title'] ) && ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} else {
			echo $title;
		}

		$sympose = new Sympose_Public();
		$sympose->render_session($id, false);

		echo $args['after_widget'];

		// phpcs:enable
	}

	/**
	 * Update functon
	 *
	 * @param array $new_instance New instance.
	 * @param array $old_instance Old instance.
	 *
	 * @return array instance.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );

		return $instance;
	}

	/**
	 * Form function
	 *
	 * @param array $instance Form instance.
	 */
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
		$title    = $instance['title'];
		?>
		<p><i><?php esc_html_e( 'Shows the session information.', 'sympose' ); ?></i></p>
		<?php do_action( "sympose_widget_{$this->id_base}_content" ); ?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">Title:
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
					   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
					   value="<?php echo esc_attr( $title ); ?>"/>
			</label>
		</p>
		<?php
	}
}

add_action(
	'widgets_init',
	function () {
		register_widget( 'Sympose_Session_Information' );
	}
);
