<?php
/**
@package New Photo Gallery
Plugin Name: New Photo Gallery
Plugin URI: https://awplife.com/wordpress-plugins/photo-gallery-premium/
Description: new photo gallery plugin with lightbox preview for Wordpress
Version: 1.1.2
Author: A WP Life
Author URI: https://awplife.com/
License: GPLv2 or later
Text Domain: new-photo-gallery
Domain Path: /languages
*/
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'New_Photo_Gallery' ) ) {

	class New_Photo_Gallery {

		protected $protected_plugin_api;
		protected $ajax_plugin_nonce;
		
		public function __construct() {
			$this->_constants();
			$this->_hooks();
		}
		
		protected function _constants() {
			//Plugin Version
			define( 'NPG_VER', '1.1.2' );
			
			//Plugin Text Domain
			define( 'NPG_TXTDM','new-photo-gallery' );

			//Plugin Name
			define( 'NPG_PLUGIN_NAME', __( 'New Photo Gallery', NPG_TXTDM ) );

			//Plugin Slug
			define( 'NPG_PLUGIN_SLUG', '_light_image_gallery' );

			//Plugin Directory Path
			define( 'NPG_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

			//Plugin Directory URL
			define( 'NPG_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

		} // end of constructor function
		
		/**
		 * Setup the default filters and actions
		 */
		protected function _hooks() {
			
			//Load text domain
			add_action( 'plugins_loaded', array( $this, '_load_textdomain' ) );
			
			//add gallery menu item, change menu filter for multisite
			add_action( 'admin_menu', array( $this, '_npg_menus' ), 101 );
			
			//create Image Gallery Custom Post
			add_action( 'init', array( $this, 'light_image_gallery' ));
			
			//Add meta box to custom post
			add_action( 'add_meta_boxes', array( $this, '_admin_add_meta_box' ) );
			 
			//loaded during admin init 
			add_action( 'admin_init', array( $this, '_admin_add_meta_box' ) );
			
			add_action('wp_ajax_photo_gallery_js', array(&$this, '_ajax_light_image_gallery'));
		
			add_action('save_post', array(&$this, '_lg_save_settings'));

			//shortcode compatibility in Text Widgets
			add_filter('widget_text', 'do_shortcode');
			
			// add npg cpt shortcode column - manage_{$post_type}_posts_columns
			add_filter( 'manage__light_image_gallery_posts_columns', array(&$this, 'set_light_image_gallery_shortcode_column_name') );
			
			// add npg cpt shortcode column data - manage_{$post_type}_posts_custom_column
			add_action( 'manage__light_image_gallery_posts_custom_column' , array(&$this, 'custom_light_image_gallery_shodrcode_data'), 10, 2 );

			add_action( 'wp_enqueue_scripts', array(&$this, 'ngp_enqueue_scripts_in_header') );
			
		} // end of hook function
		
		public function ngp_enqueue_scripts_in_header() {
			wp_enqueue_script('jquery');
		}
		
		// npg cpt shortcode column before date columns
		public function set_light_image_gallery_shortcode_column_name($defaults) {
			$new = array();
			$shortcode = $columns['_light_image_gallery_shortcode'];  // save the tags column
			unset($defaults['tags']);	// remove it from the columns list

			foreach($defaults as $key=>$value) {
				if($key=='date') {  // when we find the date column
					$new['_light_image_gallery_shortcode'] = __( 'Shortcode', APT_TXTDM );  // put the tags column before it
				}
				$new[$key] = $value;
			}
			return $new;
		}
		
		// npg cpt shortcode column data
		public function custom_light_image_gallery_shodrcode_data( $column, $post_id ) {
			switch ( $column ) {
				case '_light_image_gallery_shortcode' :
					echo "<input type='text' class='button button-primary' id='light-image-gallery-shortcode-$post_id' value='[NPG id=$post_id]' style='font-weight:bold; background-color:#32373C; color:#FFFFFF; text-align:center;' />";
					echo "<input type='button' class='button button-primary' onclick='return PHOTOCopyShortcode$post_id();' readonly value='Copy' style='margin-left:4px;' />";
					echo "<span id='copy-msg-$post_id' class='button button-primary' style='display:none; background-color:#32CD32; color:#FFFFFF; margin-left:4px; border-radius: 4px;'>copied</span>";
					echo "<script>
						function PHOTOCopyShortcode$post_id() {
							var copyText = document.getElementById('light-image-gallery-shortcode-$post_id');
							copyText.select();
							document.execCommand('copy');
							
							//fade in and out copied message
							jQuery('#copy-msg-$post_id').fadeIn('1000', 'linear');
							jQuery('#copy-msg-$post_id').fadeOut(2500,'swing');
						}
						</script>
					";
				break;
			}
		}
		
		// Loads the language file
		public function _load_textdomain() {
			load_plugin_textdomain( NPG_TXTDM, false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
		}
		
		// Adds the photo gallery menus
		public function _npg_menus() {
			$docs_menu = add_submenu_page( 'edit.php?post_type='.NPG_PLUGIN_SLUG, __( 'Docs', NPG_TXTDM ), __( 'Docs', NPG_TXTDM ), 'administrator', 'npg-doc-page', array( $this, '_npg_doc_page') );
			$upgrade_premium_menu = add_submenu_page( 'edit.php?post_type='.NPG_PLUGIN_SLUG, __( 'Upgrade Premium', NPG_TXTDM ), __( 'Upgrade Premium', NPG_TXTDM ), 'administrator', 'npg-upgrade-premium', array( $this, '_npg_upgrade_page') );
			$themes_menu = add_submenu_page( 'edit.php?post_type='.NPG_PLUGIN_SLUG, __( 'Our Themes', NPG_TXTDM ), __( 'Our Themes', NPG_TXTDM ), 'administrator', 'npg-themes', array( $this, '_npg_theme_page') );
			$plugins_menu = add_submenu_page( 'edit.php?post_type='.NPG_PLUGIN_SLUG, __( 'Our Plugins', NPG_TXTDM ), __( 'Our Plugins', NPG_TXTDM ), 'administrator', 'npg-plugins', array( $this, '_npg_featured_plugins') );
		}
		
		// Photo Gallery Custom Post
		public function light_image_gallery() {
			$labels = array(
				'name'                => __( 'New Photo Gallery', 'Post Type General Name', NPG_TXTDM ),
				'singular_name'       => __( 'New Photo Gallery', 'Post Type Singular Name', NPG_TXTDM ),
				'menu_name'           => __( 'New Photo Gallery', NPG_TXTDM ),
				'name_admin_bar'      => __( 'New Photo Gallery', NPG_TXTDM ),
				'parent_item_colon'   => __( 'Parent Item:', NPG_TXTDM ),
				'all_items'           => __( 'All Photo Gallery', NPG_TXTDM ),
				'add_new_item'        => __( 'Add New Photo Gallery', NPG_TXTDM ),
				'add_new'             => __( 'Add New Gallery', NPG_TXTDM ),
				'new_item'            => __( 'New Photo Gallery', NPG_TXTDM ),
				'edit_item'           => __( 'Edit New Photo Gallery', NPG_TXTDM ),
				'update_item'         => __( 'Update New Photo Gallery', NPG_TXTDM ),
				'search_items'        => __( 'Search New Photo Gallery', NPG_TXTDM ),
				'not_found'           => __( 'Photo Gallery Not found', NPG_TXTDM ),
				'not_found_in_trash'  => __( 'Photo Gallery Not found in Trash', NPG_TXTDM ),
			);
			$args = array(
				'label'               => __( 'New Photo Gallery', NPG_TXTDM ),
				'label'               => __( 'New Photo Gallery', NPG_TXTDM ),
				'description'         => __( 'Custom Post Type For New Photo Gallery', NPG_TXTDM ),
				'labels'              => $labels,
				'supports'            => array( 'title'),
				'taxonomies'          => array(),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => true,
				'menu_position'       => 65,
				'menu_icon'           => 'dashicons-images-alt2',
				'show_in_admin_bar'   => true,
				'show_in_nav_menus'   => true,
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => false,
				'publicly_queryable'  => true,
				'capability_type'     => 'page',
			);
			register_post_type( '_light_image_gallery', $args );
			
		} // end of post type function
		
		// gallery setting meta box
		public function _admin_add_meta_box() {
			// Syntax: add_meta_box( $id, $title, $callback, $screen, $context, $priority, $callback_args );
			add_meta_box( '', __('Add Photos To Photo Gallery', NPG_TXTDM), array(&$this, 'lg_upload_multiple_images'), '_light_image_gallery', 'normal', 'default' );
		}
		
		public function lg_upload_multiple_images($post) { 
			wp_enqueue_script('media-upload');
			wp_enqueue_script('awplife-npg-uploader-js', NPG_PLUGIN_URL . 'js/awplife-npg-uploader.js', array('jquery'));
			wp_enqueue_style('awplife-npg-uploader-css', NPG_PLUGIN_URL . 'css/awplife-npg-uploader.css');
			wp_enqueue_media();
			?>
			<div id="photo-gallery">
				<input type="button" id="remove-all-photos" name="remove-all-photos" class="button button-large remove-all-photos" rel="" value="<?php _e('Delete All Photos', NPG_TXTDM); ?>">
				<ul id="remove-photos" class="photo-box">
					<?php
					$allimagesetting = unserialize(base64_decode(get_post_meta( $post->ID, 'awl_lg_settings_'.$post->ID, true)));
					if(isset($allimagesetting['slide-ids'])) {
					$count = 0;
					foreach($allimagesetting['slide-ids'] as $id) {
						$thumbnail = wp_get_attachment_image_src($id, 'medium', true);
						$attachment = get_post( $id );
						$image_link =  $allimagesetting['slide-link'][$count];
						$image_type =  $allimagesetting['slide-type'][$count];
						?>
						<li class="photo-single">
							<img class="photo" src="<?php echo $thumbnail[0]; ?>" alt="<?php echo get_the_title($id); ?>">
							<input type="hidden" id="slide-ids[]" name="slide-ids[]" value="<?php echo $id; ?>" />
							<!-- Image Title, Caption, Alt Text, Description-->
							<select id="slide-type[]" name="slide-type[]" class="form-control photo-type" value=" <?php _e($image_type, NPG_TXTDM); ?>" >
								<option value="image" <?php if($image_type == "image") echo "selected=selected"; ?>><?php _e('Image', NPG_TXTDM); ?></option>
								<option value="video" <?php if($image_type == "video") echo "selected=selected"; ?>><?php _e('Video', NPG_TXTDM); ?></option>
							</select>
							<input type="text" name="slide-title[]" id="slide-title[]" class="photo-title" placeholder="<?php _e('Photo Title', NPG_TXTDM); ?>" value="<?php _e(get_the_title($id), NPG_TXTDM); ?>">
							<input type="text" name="slide-link[]" id="slide-link[]" class="photo-link" placeholder="<?php _e('YouTube / Vimeo Video URL', NPG_TXTDM); ?>" value="<?php echo $image_link; ?>">
							<input type="button" name="remove-photo" id="remove-photo" class="button button-danger photo-remove" value="<?php _e('Delete', NPG_TXTDM); ?>">
						</li>
						<?php $count++; } // end of for each
					} //end of if
				?>
				</ul>
			</div>
			
			<!--Add New Photo Button-->
			<div name="add-new-photos" id="add-new-photos" class="add-new-photos">
				<div class="menu-icon dashicons dashicons-format-image"></div>
				<div class="add-text"><?php _e('Add Photo', NPG_TXTDM); ?></div>
			</div>
			<div style="clear:left;"></div>
			<br>
			<h1><?php _e('Configure Settings For Photo Gallery', NPG_TXTDM); ?></h1>
			<hr>
			<?php
			require_once('settings.php');
		} // end of upload multiple image
		
		public function _ajax_light_image_gallery() {
			echo $this->_lg_ajax_callback_function($_POST['slideId']);
			die;
		}
		
		public function _lg_ajax_callback_function($id) {
			//wp_get_attachment_image_src ( int $attachment_id, string|array $size = 'thumbnail', bool $icon = false )
			//thumb, thumbnail, medium, large, post-thumbnail
			$thumbnail = wp_get_attachment_image_src($id, 'medium', true);
			$attachment = get_post( $id ); // $id = attachment id
			?>
			<li class="photo-single">
				<img class="photo" src="<?php echo $thumbnail[0]; ?>" alt="<?php echo get_the_title($id); ?>">
				<input type="hidden" id="slide-ids[]" name="slide-ids[]" value="<?php echo $id; ?>" />
				<select id="slide-type[]" name="slide-type[]" class="form-control photo-type" value="<?php _e($image_type, NPG_TXTDM); ?>" >
					<option value="image" <?php if($image_type == "image") echo "selected=selected"; ?>><?php _e('Image', NPG_TXTDM); ?></option>
					<option value="video" <?php if($image_type == "video") echo "selected=selected"; ?>><?php _e('Video', NPG_TXTDM); ?></option>
				</select>
				<input type="text" name="slide-title[]" id="slide-title[]" class="photo-title" placeholder="<?php _e('Photo Title', NPG_TXTDM); ?>" value="<?php _e(get_the_title($id), NPG_TXTDM); ?>">
				<input type="text" name="slide-link[]" id="slide-link[]" class="photo-link" placeholder="<?php _e('YouTube / Vimeo Video URL', NPG_TXTDM); ?>">
				<input type="button" name="remove-photo" id="remove-photo" class="button button-danger photo-remove" value="<?php _e('Delete', NPG_TXTDM); ?>">
			</li>
			<?php
		} 
		
		public function _lg_save_settings($post_id) {
			if ( isset( $_POST['ig-settings'] ) == "ig-save-settings" ) {
				$image_ids = $_POST['slide-ids'];
				$image_titles = $_POST['slide-title'];
				$image_type = $_POST['slide-type'];
				$i = 0;
				foreach($image_ids as $image_id) {
					$single_image_update = array(
						'ID'           => $image_id,
						'post_title'   => $image_titles[$i],
					);
					wp_update_post( $single_image_update );
					$i++;
				}
				$awl_light_image_gallery_shortcode_setting = "awl_lg_settings_".$post_id;
				update_post_meta($post_id, $awl_light_image_gallery_shortcode_setting, base64_encode(serialize($_POST)));
			}
		}// end save setting
		
		// doc page
		public function _npg_doc_page() {
			require_once('docs.php');
		}
		
		// upgrade premium
		public function _npg_upgrade_page() {
			require_once('upgrade-premium.php');
		}
		
		// a wp life plugins page
		public function _npg_featured_plugins() {
			require_once('our-plugins/awplife-plugins.php');
		}

		// a wp life themes page
		public function _npg_theme_page() {
			require_once('our-themes/awplife-themes.php');
		}
	}// end of class

	/**
	 * Instantiates the Class
	 */
	$lg_gallery_object = new New_Photo_Gallery();
	require_once('shortcode.php');
} // end of class exists
?>