<?php

class Sympose_Session_Information extends WP_Widget {

	function __construct() {
		// Instantiate the parent object
		parent::__construct( false, 'Sympose Session Information' );
	}

	function widget( $args, $instance ) {
        $id = get_the_ID();
        $post = get_post($id);

        $sympose = new Sympose_Public();
        $prefix = $sympose->get('prefix');

        $day = $sympose->get_session_day($id);
        $timestamp = get_term_meta($day->term_id, $prefix.'event_date', true);

        if (empty($timestamp) || !is_numeric($timestamp)) {
            $timestamp = get_term_meta($day->parent, $prefix.'event_date', true);
            if (empty($timestamp) || !is_numeric($timestamp)) {
                _e('Error: Please set a valid date for the event.', 'sympose'); 
                return;
            }
        }
            
        
        $start = new Datetime();
        $start->setTimestamp($timestamp);
        $time = explode(':', get_post_meta($id, $prefix.'session_start', true));
        $start->setTime($time[0], $time[1]);

        $end = new Datetime();
        $end->setTimestamp($timestamp);
        $time = explode(':', get_post_meta($id, $prefix.'session_end', true));
        $end->setTime($time[0], $time[1]);
        
        $date = new Datetime();
        $date->setTimestamp($timestamp);

        $dayname = ($day) ? $dayname = '<h3>'.$day->name.'</h3>' : $dayname = "";
        $datestring = $date->format(get_option('date_format'));

        $startstring = $start->format(get_option('time_format'));
        $endstring = $end->format(get_option('time_format'));
        
        if (isset($instance['title']) && !empty($instance['title'])) {
            echo $args['before_title'].$instance['title'].$args['after_title'];
        }

        echo $args['before_widget'];
            echo $dayname;
            echo '<p>'.$datestring.'<br/> '.$startstring.' - '.$endstring.'</p>';
            do_action('sympose_extend_information_widget', $id);
        echo $args['after_widget'];
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
        $instance['title'] = sanitize_text_field($new_instance['title']);
        return $instance;
	}

	function form( $instance ) {
        $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
        $title = $instance['title'];
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title: 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" 
                    name="<?php echo $this->get_field_name('title'); ?>" type="text" 
                    value="<?php echo $title; ?>" />
            </label>
            </p>
        <?php
	}
}

add_action( 'widgets_init', function() {
    register_widget( 'Sympose_Session_Information' );
} );